<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\ChartOfAccount;
use Illuminate\Support\Facades\DB;

// الحصول على أول حساب موجود للتحقق من قيمة company_id
$firstAccount = ChartOfAccount::first();

if ($firstAccount) {
    echo "قيمة company_id للحساب الأول: " . $firstAccount->company_id . "\n";
} else {
    echo "لا توجد حسابات في النظام.\n";
}

// الحصول على قائمة الشركات المستخدمة في الحسابات
$companies = ChartOfAccount::distinct('company_id')->pluck('company_id')->toArray();

echo "الشركات المستخدمة في الحسابات: " . implode(', ', $companies) . "\n";

echo "تم الانتهاء من العملية.";
