<?php

require_once __DIR__ . '/vendor/autoload.php';

use App\Models\ChartOfAccount;
use Illuminate\Support\Facades\DB;

// تهيئة Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

echo "فحص هيكل الحسابات للشركة رقم 3...\n\n";

// البحث عن حساب الأصول
$assetsAccount = ChartOfAccount::where('company_id', 3)
    ->where('account_code', '1000')
    ->first();

if ($assetsAccount) {
    echo "حساب الأصول (ID: {$assetsAccount->id}):\n";
    echo "  الاسم: {$assetsAccount->name}\n";
    echo "  الرمز: {$assetsAccount->account_code}\n";
    echo "  المستوى: {$assetsAccount->level}\n";
    echo "  الحساب الأب: " . ($assetsAccount->parent_id ?: 'لا يوجد') . "\n\n";

    // البحث عن حساب الأصول المتداولة
    $currentAssetsAccount = ChartOfAccount::where('company_id', 3)
        ->where('parent_id', $assetsAccount->id)
        ->where('account_code', '1100')
        ->first();

    if ($currentAssetsAccount) {
        echo "حساب الأصول المتداولة (ID: {$currentAssetsAccount->id}):\n";
        echo "  الاسم: {$currentAssetsAccount->name}\n";
        echo "  الرمز: {$currentAssetsAccount->account_code}\n";
        echo "  المستوى: {$currentAssetsAccount->level}\n";
        echo "  الحساب الأب: {$currentAssetsAccount->parent_id}\n\n";

        // البحث عن حساب البنوك
        $bankAccount = ChartOfAccount::where('company_id', 3)
            ->where('parent_id', $currentAssetsAccount->id)
            ->where('account_code', 'BANK')
            ->first();

        if ($bankAccount) {
            echo "حساب البنوك (ID: {$bankAccount->id}):\n";
            echo "  الاسم: {$bankAccount->name}\n";
            echo "  الرمز: {$bankAccount->account_code}\n";
            echo "  المستوى: {$bankAccount->level}\n";
            echo "  الحساب الأب: {$bankAccount->parent_id}\n\n";

            // البحث عن الحسابات البنكية الفردية
            $individualBankAccounts = ChartOfAccount::where('company_id', 3)
                ->where('parent_id', $bankAccount->id)
                ->where('is_bank_account', true)
                ->get();

            echo "الحسابات البنكية الفردية (" . $individualBankAccounts->count() . "):\n";
            foreach ($individualBankAccounts as $account) {
                echo "  - حساب (ID: {$account->id}):\n";
                echo "    الاسم: {$account->name}\n";
                echo "    الرمز: {$account->account_code}\n";
                echo "    المستوى: {$account->level}\n";
                echo "    الحساب الأب: {$account->parent_id}\n";
            }
        } else {
            echo "لم يتم العثور على حساب البنوك!\n";
        }
    } else {
        echo "لم يتم العثور على حساب الأصول المتداولة!\n";
    }
} else {
    echo "لم يتم العثور على حساب الأصول!\n";
}

echo "\nتم الانتهاء من الفحص.\n";
