<?php

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\User;
use App\Models\Company;

// إيجاد المستخدم التجريبي
$user = User::where('email', 'demo@elevators.com')->first();

if (!$user) {
    echo "المستخدم التجريبي غير موجود!\n";
    exit;
}

echo "معلومات المستخدم:\n";
echo "الاسم: " . $user->name . "\n";
echo "البريد الإلكتروني: " . $user->email . "\n";
echo "معرف الشركة: " . ($user->company_id ?: "غير مرتبط بشركة") . "\n";

if ($user->company_id) {
    $company = Company::find($user->company_id);
    if ($company) {
        echo "\nمعلومات الشركة:\n";
        echo "الاسم: " . $company->name . "\n";
        echo "الحالة: " . ($company->is_active ? "نشطة" : "غير نشطة") . "\n";
    } else {
        echo "\nالشركة غير موجودة رغم وجود معرف لها!\n";
    }
} else {
    // إيجاد أول شركة نشطة
    $company = Company::where('is_active', true)->first();

    if ($company) {
        echo "\nتم العثور على شركة نشطة:\n";
        echo "المعرف: " . $company->id . "\n";
        echo "الاسم: " . $company->name . "\n";

        // ربط المستخدم بالشركة
        $user->company_id = $company->id;
        $user->save();

        echo "\nتم ربط المستخدم بالشركة بنجاح!\n";
    } else {
        echo "\nلا توجد شركات نشطة في النظام!\n";
    }
}
