<?php

// تحميل التطبيق
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// استخدام النماذج
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

// التحقق من نوع الأعمدة في جدول cash_registers
$columns = DB::select("SHOW COLUMNS FROM cash_registers WHERE Field IN ('is_active', 'is_main')");
echo "أنواع الأعمدة في جدول cash_registers:\n";
foreach ($columns as $column) {
    echo "- " . $column->Field . ": " . $column->Type . "\n";
}

// التحقق من قيم is_active و is_main في السجلات الموجودة
$registers = DB::table('cash_registers')->select('id', 'name', 'is_active', 'is_main')->get();
echo "\nقيم is_active و is_main في السجلات الموجودة:\n";
foreach ($registers as $register) {
    echo "- ID: " . $register->id . ", الاسم: " . $register->name .
        ", is_active: " . var_export($register->is_active, true) .
        ", is_main: " . var_export($register->is_main, true) . "\n";

    // عرض نوع البيانات
    echo "  نوع is_active: " . gettype($register->is_active) .
        ", نوع is_main: " . gettype($register->is_main) . "\n";
}

// التحقق من كيفية معالجة القيم المنطقية في النموذج
echo "\nالتحقق من كيفية معالجة القيم المنطقية في النموذج:\n";
$model = new App\Models\CashRegister();
echo "- الحقول القابلة للتعبئة: " . implode(', ', $model->getFillable()) . "\n";
echo "- تحويلات الأنواع: " . json_encode($model->getCasts()) . "\n";
