<?php

// تحميل التطبيق
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// استخدام النماذج
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

// التحقق من وجود جدول cash_transactions
if (Schema::hasTable('cash_transactions')) {
    echo "جدول cash_transactions موجود.\n";

    // عرض هيكل الجدول
    $columns = DB::select("SHOW COLUMNS FROM cash_transactions");
    echo "أعمدة الجدول:\n";
    foreach ($columns as $column) {
        echo "- " . $column->Field . ": " . $column->Type . " (Null: " . $column->Null . ")\n";
    }

    // عرض قيود المفاتيح الأجنبية
    $foreignKeys = DB::select("
        SELECT 
            COLUMN_NAME, 
            CONSTRAINT_NAME, 
            REFERENCED_TABLE_NAME, 
            REFERENCED_COLUMN_NAME
        FROM 
            INFORMATION_SCHEMA.KEY_COLUMN_USAGE
        WHERE 
            TABLE_SCHEMA = DATABASE() AND
            TABLE_NAME = 'cash_transactions' AND
            REFERENCED_TABLE_NAME IS NOT NULL
    ");

    echo "\nقيود المفاتيح الأجنبية:\n";
    if (count($foreignKeys) > 0) {
        foreach ($foreignKeys as $fk) {
            echo "- " . $fk->COLUMN_NAME . " -> " . $fk->REFERENCED_TABLE_NAME . "." . $fk->REFERENCED_COLUMN_NAME . " (" . $fk->CONSTRAINT_NAME . ")\n";
        }
    } else {
        echo "لا توجد قيود مفاتيح أجنبية.\n";
    }
} else {
    echo "جدول cash_transactions غير موجود.\n";
}
