<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// Get first cash transaction
$transaction = \App\Models\CashTransaction::first();
echo "Cash Transaction Details:\n";
print_r($transaction->toArray());

// Check if there are any journal entries
$journalEntries = \App\Models\JournalEntry::count();
echo "\nJournal Entries Count: " . $journalEntries . "\n";

// Check if there are any cash transaction entries
$cashTransactionEntries = DB::table('cash_transaction_entries')->count();
echo "Cash Transaction Entries Count: " . $cashTransactionEntries . "\n";

// Check active fiscal year
$fiscalYear = \App\Models\FiscalYear::where('is_active', true)->first();
echo "\nActive Fiscal Year: " . ($fiscalYear ? $fiscalYear->name : 'None') . "\n";

// Check accounting periods
$accountingPeriods = \App\Models\AccountingPeriod::where('fiscal_year_id', $fiscalYear ? $fiscalYear->id : 0)->get();
echo "Accounting Periods:\n";
foreach ($accountingPeriods as $period) {
    echo "- " . $period->name . " (" . $period->start_date . " to " . $period->end_date . ")\n";
}
