<?php
require_once __DIR__ . '/vendor/autoload.php';

use App\Models\Bank;
use App\Models\ChartOfAccount;
use Illuminate\Support\Facades\DB;

// Initialize Laravel application
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

try {
    // Check all chart of accounts for company ID 3
    $accounts = ChartOfAccount::where('company_id', 3)
        ->orderBy('id')
        ->get();

    echo "All chart of accounts for company ID 3:\n";
    echo "----------------------------------------\n";
    foreach ($accounts as $account) {
        echo "ID: {$account->id}, Code: {$account->account_code}, Name: {$account->name}, Parent ID: {$account->parent_id}, Is Parent: " . ($account->is_parent ? 'Yes' : 'No') . ", Is Bank: " . ($account->is_bank_account ? 'Yes' : 'No') . "\n";
    }

    // Check if there's a BANK account in the database that might not be showing up in the model
    $bankAccountsRaw = DB::select("SELECT * FROM chart_of_accounts WHERE company_id = 3 AND account_code = 'BANK'");

    echo "\nDirect SQL query for BANK accounts in company ID 3:\n";
    echo "---------------------------------------------------\n";
    foreach ($bankAccountsRaw as $account) {
        echo "ID: {$account->id}, Code: {$account->account_code}, Name: {$account->name}, Parent ID: {$account->parent_id}, Is Parent: " . ($account->is_parent ? 'Yes' : 'No') . ", Is Bank: " . ($account->is_bank_account ? 'Yes' : 'No') . "\n";
    }

    // Check for any account with similar name
    $similarAccounts = ChartOfAccount::where('company_id', 3)
        ->where('name', 'like', '%بنك%')
        ->orWhere('name', 'like', '%bank%')
        ->get();

    echo "\nAccounts with 'bank' or 'بنك' in the name for company ID 3:\n";
    echo "--------------------------------------------------------\n";
    foreach ($similarAccounts as $account) {
        echo "ID: {$account->id}, Code: {$account->account_code}, Name: {$account->name}, Parent ID: {$account->parent_id}, Is Parent: " . ($account->is_parent ? 'Yes' : 'No') . ", Is Bank: " . ($account->is_bank_account ? 'Yes' : 'No') . "\n";
    }

    // Check for any account with BANK in the code
    $bankCodeAccounts = ChartOfAccount::where('company_id', 3)
        ->where('account_code', 'like', '%BANK%')
        ->get();

    echo "\nAccounts with 'BANK' in the code for company ID 3:\n";
    echo "------------------------------------------------\n";
    foreach ($bankCodeAccounts as $account) {
        echo "ID: {$account->id}, Code: {$account->account_code}, Name: {$account->name}, Parent ID: {$account->parent_id}, Is Parent: " . ($account->is_parent ? 'Yes' : 'No') . ", Is Bank: " . ($account->is_bank_account ? 'Yes' : 'No') . "\n";
    }

    // Let's also check the structure of the chart_of_accounts table
    $tableInfo = DB::select("SHOW CREATE TABLE chart_of_accounts");

    echo "\nTable structure for chart_of_accounts:\n";
    echo "-------------------------------------\n";
    print_r($tableInfo);
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
