<?php

require_once __DIR__ . '/vendor/autoload.php';

use App\Models\ChartOfAccount;
use Illuminate\Support\Facades\DB;

// تهيئة Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

echo "فحص حسابات البنوك...\n";

// البحث عن حسابات البنوك الرئيسية (بما في ذلك المحذوفة)
$bankAccounts = ChartOfAccount::withTrashed()->where('account_code', 'BANK')->get();

foreach ($bankAccounts as $bank) {
    echo "Bank ID: {$bank->id}, Company ID: {$bank->company_id}, Parent ID: {$bank->parent_id}, Name: {$bank->name}, Deleted: " . ($bank->trashed() ? "Yes" : "No") . "\n";

    // البحث عن الحساب الأب
    $parent = ChartOfAccount::withTrashed()->find($bank->parent_id);
    if ($parent) {
        echo "  Parent Account: {$parent->id}, Name: {$parent->name}, Code: {$parent->account_code}, Deleted: " . ($parent->trashed() ? "Yes" : "No") . "\n";
    } else {
        echo "  Parent Account: Not found!\n";
    }

    // البحث عن الحسابات الفرعية
    $children = ChartOfAccount::withTrashed()->where('parent_id', $bank->id)->get();
    echo "  Child Accounts: " . $children->count() . "\n";

    foreach ($children as $child) {
        echo "    - Child ID: {$child->id}, Name: {$child->name}, Code: {$child->account_code}, Deleted: " . ($child->trashed() ? "Yes" : "No") . "\n";
    }

    echo "\n";
}

// البحث عن حسابات الأصول المتداولة
echo "فحص حسابات الأصول المتداولة...\n";
$currentAssets = ChartOfAccount::where('account_code', '1100')->get();

foreach ($currentAssets as $asset) {
    echo "Current Asset ID: {$asset->id}, Company ID: {$asset->company_id}, Name: {$asset->name}\n";

    // البحث عن الحسابات الفرعية المباشرة
    $children = ChartOfAccount::where('parent_id', $asset->id)->get();
    echo "  Direct Children: " . $children->count() . "\n";

    foreach ($children as $child) {
        echo "    - Child ID: {$child->id}, Name: {$child->name}, Code: {$child->account_code}\n";
    }

    echo "\n";
}

echo "تم الانتهاء من الفحص.\n";
