<?php

require_once __DIR__ . '/vendor/autoload.php';

use App\Models\ChartOfAccount;

// تهيئة Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// البحث عن حساب البنوك الرئيسي
$bankAccount = ChartOfAccount::where('account_code', 'BANK')->first();

if ($bankAccount) {
    echo "حساب البنوك الرئيسي:\n";
    echo "ID: " . $bankAccount->id . "\n";
    echo "الاسم: " . $bankAccount->name . "\n";
    echo "الرمز: " . $bankAccount->account_code . "\n";
    echo "معرف الحساب الأب: " . $bankAccount->parent_id . "\n";

    // البحث عن الحساب الأب
    if ($bankAccount->parent_id) {
        $parentAccount = ChartOfAccount::find($bankAccount->parent_id);
        if ($parentAccount) {
            echo "\nمعلومات الحساب الأب:\n";
            echo "ID: " . $parentAccount->id . "\n";
            echo "الاسم: " . $parentAccount->name . "\n";
            echo "الرمز: " . $parentAccount->account_code . "\n";
        } else {
            echo "\nلم يتم العثور على الحساب الأب!\n";
        }
    } else {
        echo "\nليس لديه حساب أب!\n";
    }

    // البحث عن حساب الأصول المتداولة
    $currentAssetsAccount = ChartOfAccount::where('account_code', '1100')
        ->where('company_id', $bankAccount->company_id)
        ->first();

    if ($currentAssetsAccount) {
        echo "\nمعلومات حساب الأصول المتداولة:\n";
        echo "ID: " . $currentAssetsAccount->id . "\n";
        echo "الاسم: " . $currentAssetsAccount->name . "\n";
        echo "الرمز: " . $currentAssetsAccount->account_code . "\n";
    } else {
        echo "\nلم يتم العثور على حساب الأصول المتداولة!\n";
    }
} else {
    echo "لم يتم العثور على حساب البنوك الرئيسي!\n";
}
