<?php

require_once __DIR__ . '/vendor/autoload.php';

use App\Models\ChartOfAccount;

// تهيئة Laravel
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// البحث عن جميع حسابات البنوك الرئيسية
$bankAccounts = ChartOfAccount::where('account_code', 'BANK')->get();

echo "عدد حسابات البنوك الرئيسية: " . count($bankAccounts) . "\n";

foreach ($bankAccounts as $account) {
    echo "ID: " . $account->id . ", الاسم: " . $account->name . ", الشركة: " . $account->company_id . ", الحساب الأب: " . $account->parent_id . "\n";

    // البحث عن الحساب الأب
    if ($account->parent_id) {
        $parentAccount = ChartOfAccount::find($account->parent_id);
        if ($parentAccount) {
            echo "  الحساب الأب: ID: " . $parentAccount->id . ", الاسم: " . $parentAccount->name . ", الرمز: " . $parentAccount->account_code . "\n";
        } else {
            echo "  لم يتم العثور على الحساب الأب!\n";
        }
    } else {
        echo "  ليس لديه حساب أب!\n";
    }

    echo "\n";
}

// البحث عن حسابات البنوك الفرعية
$bankSubAccounts = ChartOfAccount::where('is_bank_account', true)
    ->whereNotIn('account_code', ['BANK'])
    ->get();

echo "\nعدد حسابات البنوك الفرعية: " . count($bankSubAccounts) . "\n";

foreach ($bankSubAccounts as $account) {
    echo "ID: " . $account->id . ", الاسم: " . $account->name . ", الرمز: " . $account->account_code . ", الشركة: " . $account->company_id . ", الحساب الأب: " . $account->parent_id . "\n";

    // البحث عن الحساب الأب
    if ($account->parent_id) {
        $parentAccount = ChartOfAccount::find($account->parent_id);
        if ($parentAccount) {
            echo "  الحساب الأب: ID: " . $parentAccount->id . ", الاسم: " . $parentAccount->name . ", الرمز: " . $parentAccount->account_code . "\n";
        } else {
            echo "  لم يتم العثور على الحساب الأب!\n";
        }
    } else {
        echo "  ليس لديه حساب أب!\n";
    }

    echo "\n";
}
