<?php
require 'vendor/autoload.php';
require 'bootstrap/app.php';

// تهيئة التطبيق
$app = $GLOBALS['app'];
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// استخراج الحسابات التي تحتاج إلى فحص
$accounts = DB::table('chart_of_accounts')
    ->whereIn('account_code', ['111001', 'BANK-1758817072', 'C00007', 'ADJ-DIFF', '4000'])
    ->get(['id', 'account_code', 'name', 'current_balance', 'account_type']);

foreach ($accounts as $account) {
    echo "=== فحص الحساب: {$account->account_code} - {$account->name} ===\n";
    echo "الرصيد الحالي: {$account->current_balance}\n";
    echo "نوع الحساب: {$account->account_type}\n\n";

    // استخراج بنود القيود المرتبطة بالحساب
    $items = DB::table('journal_entry_items')
        ->join('journal_entries', 'journal_entries.id', '=', 'journal_entry_items.journal_entry_id')
        ->where('journal_entry_items.account_id', $account->id)
        ->select(
            'journal_entries.id as entry_id',
            'journal_entries.entry_number',
            'journal_entries.entry_date',
            'journal_entry_items.debit',
            'journal_entry_items.credit',
            'journal_entry_items.description'
        )
        ->orderBy('journal_entries.entry_date')
        ->get();

    if (count($items) > 0) {
        echo "بنود القيود المرتبطة بالحساب:\n";
        $totalDebit = 0;
        $totalCredit = 0;

        foreach ($items as $item) {
            echo "القيد رقم: {$item->entry_number} (ID: {$item->entry_id}), التاريخ: {$item->entry_date}\n";
            echo "المدين: {$item->debit}, الدائن: {$item->credit}, الوصف: {$item->description}\n\n";

            $totalDebit += $item->debit;
            $totalCredit += $item->credit;
        }

        echo "إجمالي المدين: {$totalDebit}\n";
        echo "إجمالي الدائن: {$totalCredit}\n";

        // حساب الرصيد المتوقع
        $expectedBalance = 0;
        if (in_array($account->account_type, ['asset', 'expense'])) {
            $expectedBalance = $totalDebit - $totalCredit;
        } else {
            $expectedBalance = $totalCredit - $totalDebit;
        }

        echo "الرصيد المتوقع: {$expectedBalance}\n";
        echo "الفرق بين الرصيد الحالي والمتوقع: " . ($account->current_balance - $expectedBalance) . "\n";
    } else {
        echo "لا توجد بنود مرتبطة بهذا الحساب.\n";
    }

    echo "\n" . str_repeat('-', 50) . "\n\n";
}

// فحص إجمالي الأرصدة
echo "=== فحص إجمالي الأرصدة ===\n\n";

// حساب إجمالي المدين والدائن من بنود القيود
$totalDebitsCredits = DB::table('journal_entry_items')
    ->selectRaw('SUM(debit) as total_debit, SUM(credit) as total_credit')
    ->first();

echo "إجمالي المدين من بنود القيود: {$totalDebitsCredits->total_debit}\n";
echo "إجمالي الدائن من بنود القيود: {$totalDebitsCredits->total_credit}\n";
echo "الفرق: " . ($totalDebitsCredits->total_debit - $totalDebitsCredits->total_credit) . "\n\n";

// حساب إجمالي أرصدة الحسابات
$debitAccounts = DB::table('chart_of_accounts')
    ->whereIn('account_type', ['asset', 'expense'])
    ->sum('current_balance');

$creditAccounts = DB::table('chart_of_accounts')
    ->whereIn('account_type', ['liability', 'equity', 'revenue'])
    ->sum('current_balance');

echo "إجمالي أرصدة حسابات المدين: {$debitAccounts}\n";
echo "إجمالي أرصدة حسابات الدائن: {$creditAccounts}\n";
echo "الفرق: " . ($debitAccounts - $creditAccounts) . "\n";
