<?php

namespace App\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

class ActiveColumnScope implements Scope
{
    /**
     * تطبيق النطاق على استعلام Eloquent.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @return void
     */
    public function apply(Builder $builder, Model $model)
    {
        // لا نقوم بأي شيء هنا، سنتعامل مع الاستعلامات في طريقة extend
    }

    /**
     * تسجيل الاستماع لإضافة النطاق.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @return void
     */
    public function extend(Builder $builder)
    {
        $builder->macro('withActive', function (Builder $builder) {
            return $builder;
        });

        // تعديل استعلامات where لاستبدال active بـ is_active
        $this->replaceWhereActive($builder);
    }

    /**
     * استبدال استعلامات where التي تستخدم عمود active بـ is_active
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $builder
     * @return void
     */
    protected function replaceWhereActive(Builder $builder)
    {
        $query = $builder->getQuery();
        
        // تعديل طريقة where
        $originalWhere = $query->where;
        $query->where = function ($column, $operator = null, $value = null, $boolean = 'and') use ($originalWhere, $query) {
            // إذا كان العمود هو 'active'، استبدله بـ 'is_active'
            if ($column === 'active') {
                $column = 'is_active';
            }
            
            // استدعاء الدالة الأصلية
            return $originalWhere->call($query, $column, $operator, $value, $boolean);
        };
    }
}