<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to the "home" route for your application.
     *
     * Typically, users are redirected here after authentication.
     *
     * @var string
     */
    public const HOME = '/home';

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     *
     * @return void
     */
    public function boot()
    {
        $this->configureRateLimiting();

        $this->routes(function () {
            Route::middleware('api')
                ->prefix('api')
                ->group(base_path('routes/api.php'));

            Route::middleware('web')
                ->group(base_path('routes/web.php'));

            // إضافة مسارات إعدادات الضرائب
            Route::middleware('web')
                ->group(base_path('routes/tax_settings.php'));

            // إضافة مسارات المخزون
            Route::middleware('web')
                ->group(base_path('routes/inventory.php'));

            // إضافة مسارات وحدات المخزون
            Route::middleware('web')
                ->group(base_path('routes/inventory_units.php'));

            // إضافة مسارات التقارير المالية للصيانة وإشعارات الصيانة
            Route::middleware('web')
                ->group(base_path('routes/maintenance_financial.php'));

            // إضافة مسارات الأقساط
            Route::middleware('web')
                ->group(base_path('routes/invoice_installments.php'));

            // إضافة مسارات API للأقساط
            Route::middleware('api')
                ->prefix('api')
                ->group(base_path('routes/api_installments.php'));

            // إضافة مسارات الاختبار
            Route::middleware('web')
                ->group(base_path('routes/test.php'));

            // إضافة مسارات طلبات المخزون للمصاعد
            Route::middleware('web')
                ->group(base_path('routes/elevator_inventory.php'));

            // إضافة مسارات أذونات الصرف
            Route::middleware('web')
                ->group(base_path('routes/inventory_issues.php'));

            // إضافة مسارات مرتجع المبيعات
            Route::middleware('web')
                ->group(base_path('routes/sales_returns.php'));
        });
    }

    /**
     * Configure the rate limiters for the application.
     *
     * @return void
     */
    protected function configureRateLimiting()
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });
    }
}
