<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class QueryLogServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        if (config('app.debug')) {
            DB::listen(function ($query) {
                $sql = $query->sql;
                $bindings = $query->bindings;
                $time = $query->time;

                // Log slow queries (taking more than 1 second)
                if ($time > 1000) {
                    Log::channel('daily')->warning(
                        'Slow query detected: ' . $sql .
                            ' with bindings: ' . json_encode($bindings) .
                            ' (' . ($time / 1000) . ' seconds)'
                    );
                }
            });
        }
    }
}
