<?php

namespace App\Providers;

use App\Models\Customer;
use App\Observers\CustomerObserver;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Pagination\Paginator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        // تسجيل ملفات المساعدة
        $this->app->singleton('installment.helper', function () {
            return new \App\Helpers\InstallmentHelper();
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Set PDO fetch mode directly on the connection
        $pdo = DB::connection()->getPdo();
        if ($pdo) {
            $pdo->setAttribute(\PDO::ATTR_DEFAULT_FETCH_MODE, \PDO::FETCH_ASSOC);
        }

        // استخدام Bootstrap 5 للتصفح الصفحي
        Paginator::useBootstrapFive();

        // Add a global scope to limit large result sets
        Builder::macro('safePaginate', function ($perPage = 15) {
            return $this->paginate(min($perPage, 100));
        });

        // Increase MySQL group_concat_max_len
        DB::statement('SET group_concat_max_len = 1000000');

        // Set session wait_timeout to a higher value
        DB::statement('SET SESSION wait_timeout = 300');

        // Note: max_execution_time is only available in MySQL 5.7.8 and higher
        // We'll rely on PHP's set_time_limit instead

        // تسجيل مراقب العملاء
        Customer::observe(CustomerObserver::class);
    }
}
