<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WorkOrder extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'elevator_id',
        'project_phase_id',
        'elevator_stage_id',
        'technician_id',
        'company_id',
        'status',
        'is_technically_ready',
        'order_date',
        'received_date',
        'completion_date',
        'notes',
        'created_by'
    ];

    protected $dates = [
        'order_date',
        'received_date',
        'completion_date',
        'deleted_at'
    ];

    // العلاقة مع المصعد
    public function elevator()
    {
        return $this->belongsTo(Elevator::class);
    }

    // العلاقة مع مرحلة المشروع
    public function projectPhase()
    {
        return $this->belongsTo(ProjectPhase::class, 'project_phase_id');
    }

    // العلاقة مع مرحلة المصعد
    public function elevatorStage()
    {
        return $this->belongsTo(ElevatorStage::class, 'elevator_stage_id');
    }

    // العلاقة مع الفني المسؤول
    public function technician()
    {
        return $this->belongsTo(User::class, 'technician_id');
    }

    // العلاقة مع الشركة
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    // العلاقة مع المستخدم الذي أنشأ أمر الشغل
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    // دالة مساعدة لعرض حالة أمر الشغل بالعربية
    public function getStatusTextAttribute()
    {
        $statuses = [
            'open' => 'مفتوح',
            'paused' => 'متوقف',
            'completed' => 'مكتمل',
            'archived' => 'مؤرشف'
        ];

        return $statuses[$this->status] ?? $this->status;
    }
}
