<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Warehouse
 * 
 * @property int $id
 * @property int $company_id
 * @property int|null $branch_id
 * @property string $name
 * @property string $code
 * @property string|null $address
 * @property string|null $manager_name
 * @property string|null $phone
 * @property string|null $email
 * @property bool $is_active
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Branch|null $branch
 * @property Company $company
 * @property Collection|AutoPurchaseRule[] $auto_purchase_rules
 * @property Collection|InventoryBatch[] $inventory_batches
 * @property Collection|InventorySerial[] $inventory_serials
 * @property Collection|InventoryStock[] $inventory_stocks
 * @property Collection|InventoryTransaction[] $inventory_transactions
 * @property Collection|InventoryValuation[] $inventory_valuations
 * @property Collection|PurchaseOrder[] $purchase_orders
 *
 * @package App\Models
 */
class Warehouse extends Model
{
	protected $table = 'warehouses';

	protected $casts = [
		'company_id' => 'int',
		'branch_id' => 'int',
		'is_active' => 'bool',
		'is_default' => 'bool'
	];

	protected $fillable = [
		'company_id',
		'branch_id',
		'name',
		'code',
		'address',
		'manager_name',
		'phone',
		'email',
		'is_active',
		'is_default',
		'notes'
	];

	public function branch()
	{
		return $this->belongsTo(Branch::class);
	}

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function auto_purchase_rules()
	{
		return $this->hasMany(AutoPurchaseRule::class);
	}

	public function inventory_batches()
	{
		return $this->hasMany(InventoryBatch::class);
	}

	public function inventory_serials()
	{
		return $this->hasMany(InventorySerial::class);
	}

	public function inventory_stocks()
	{
		return $this->hasMany(InventoryStock::class);
	}

	public function inventory_transactions()
	{
		return $this->hasMany(InventoryTransaction::class);
	}

	public function inventory_valuations()
	{
		return $this->hasMany(InventoryValuation::class);
	}

	public function purchase_orders()
	{
		return $this->hasMany(PurchaseOrder::class);
	}
}
