<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class UserPermission
 * 
 * @property int $id
 * @property int $user_id
 * @property int $permission_id
 * @property bool $granted
 * @property string $source
 * @property Carbon|null $expires_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property Permission $permission
 * @property User $user
 *
 * @package App\Models
 */
class UserPermission extends Model
{
	use SoftDeletes;
	protected $table = 'user_permission';

	protected $casts = [
		'user_id' => 'int',
		'permission_id' => 'int',
		'granted' => 'bool',
		'expires_at' => 'datetime'
	];

	protected $fillable = [
		'user_id',
		'permission_id',
		'granted',
		'source',
		'expires_at'
	];

	public function permission()
	{
		return $this->belongsTo(Permission::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class);
	}
}
