<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class TwoFactorToken
 * 
 * @property int $id
 * @property int $user_id
 * @property string $token
 * @property Carbon $expires_at
 * @property bool $used
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property User $user
 *
 * @package App\Models
 */
class TwoFactorToken extends Model
{
	protected $table = 'two_factor_tokens';

	protected $casts = [
		'user_id' => 'int',
		'expires_at' => 'datetime',
		'used' => 'bool'
	];

	protected $hidden = [
		'token'
	];

	protected $fillable = [
		'user_id',
		'token',
		'expires_at',
		'used'
	];

	public function user()
	{
		return $this->belongsTo(User::class);
	}
}
