<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class TaxSetting
 * 
 * @property int $id
 * @property int $company_id
 * @property string $name
 * @property float $rate
 * @property bool $is_default
 * @property bool $is_active
 * @property string|null $description
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 *
 * @package App\Models
 */
class TaxSetting extends Model
{
	protected $table = 'tax_settings';

	protected $casts = [
		'company_id' => 'int',
		'rate' => 'float',
		'is_default' => 'bool',
		'is_active' => 'bool'
	];

	protected $fillable = [
		'company_id',
		'name',
		'rate',
		'is_default',
		'is_active',
		'description'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}
}
