<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class TaxReportInvoice
 * 
 * @property int $id
 * @property int $tax_report_id
 * @property int $invoice_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Invoice $invoice
 * @property TaxReport $tax_report
 *
 * @package App\Models
 */
class TaxReportInvoice extends Model
{
	protected $table = 'tax_report_invoices';

	protected $casts = [
		'tax_report_id' => 'int',
		'invoice_id' => 'int'
	];

	protected $fillable = [
		'tax_report_id',
		'invoice_id'
	];

	public function invoice()
	{
		return $this->belongsTo(Invoice::class);
	}

	public function tax_report()
	{
		return $this->belongsTo(TaxReport::class);
	}
}
