<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class TaxReport
 * 
 * @property int $id
 * @property int $company_id
 * @property string $report_number
 * @property Carbon $start_date
 * @property Carbon $end_date
 * @property float $total_tax_collected
 * @property float $total_tax_paid
 * @property float $net_tax
 * @property string $status
 * @property string|null $notes
 * @property int $created_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property User $user
 * @property Collection|Invoice[] $invoices
 *
 * @package App\Models
 */
class TaxReport extends Model
{
	protected $table = 'tax_reports';

	protected $casts = [
		'company_id' => 'int',
		'start_date' => 'datetime',
		'end_date' => 'datetime',
		'total_tax_collected' => 'float',
		'total_tax_paid' => 'float',
		'net_tax' => 'float',
		'created_by' => 'int'
	];

	protected $fillable = [
		'company_id',
		'report_number',
		'start_date',
		'end_date',
		'total_tax_collected',
		'total_tax_paid',
		'net_tax',
		'status',
		'notes',
		'created_by'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'created_by');
	}

	public function invoices()
	{
		return $this->belongsToMany(Invoice::class, 'tax_report_invoices')
					->withPivot('id')
					->withTimestamps();
	}
}
