<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class TaxBracket
 * 
 * @property int $id
 * @property int $company_id
 * @property string|null $name
 * @property float $min_amount
 * @property float|null $max_amount
 * @property float|null $tax_rate
 * @property bool|null $is_active
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property User|null $user
 *
 * @package App\Models
 */
class TaxBracket extends Model
{
	protected $table = 'tax_brackets';

	protected $casts = [
		'company_id' => 'int',
		'min_amount' => 'float',
		'max_amount' => 'float',
		'tax_rate' => 'float',
		'is_active' => 'bool',
		'created_by' => 'int',
		'updated_by' => 'int'
	];

	protected $fillable = [
		'company_id',
		'name',
		'min_amount',
		'max_amount',
		'tax_rate',
		'is_active',
		'created_by',
		'updated_by'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'updated_by');
	}
}
