<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class SurveyResponse
 * 
 * @property int $id
 * @property int $company_id
 * @property int $survey_id
 * @property int $customer_id
 * @property string|null $responses
 * @property float|null $overall_rating
 * @property string|null $feedback
 * @property Carbon $submitted_at
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property Customer $customer
 * @property CustomerSurvey $customer_survey
 *
 * @package App\Models
 */
class SurveyResponse extends Model
{
	use SoftDeletes;
	protected $table = 'survey_responses';

	protected $casts = [
		'company_id' => 'int',
		'survey_id' => 'int',
		'customer_id' => 'int',
		'overall_rating' => 'float',
		'submitted_at' => 'datetime'
	];

	protected $fillable = [
		'company_id',
		'survey_id',
		'customer_id',
		'responses',
		'overall_rating',
		'feedback',
		'submitted_at'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function customer()
	{
		return $this->belongsTo(Customer::class);
	}

	public function customer_survey()
	{
		return $this->belongsTo(CustomerSurvey::class, 'survey_id');
	}
}
