<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class SupplierEvaluation
 * 
 * @property int $id
 * @property int $company_id
 * @property int $supplier_id
 * @property int $created_by
 * @property Carbon $evaluation_date
 * @property float $quality_rating
 * @property float $delivery_rating
 * @property float $price_rating
 * @property float $service_rating
 * @property float $overall_rating
 * @property string|null $strengths
 * @property string|null $weaknesses
 * @property string|null $improvement_areas
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property User $user
 * @property Supplier $supplier
 *
 * @package App\Models
 */
class SupplierEvaluation extends Model
{
	protected $table = 'supplier_evaluations';

	protected $casts = [
		'company_id' => 'int',
		'supplier_id' => 'int',
		'created_by' => 'int',
		'evaluation_date' => 'datetime',
		'quality_rating' => 'float',
		'delivery_rating' => 'float',
		'price_rating' => 'float',
		'service_rating' => 'float',
		'overall_rating' => 'float'
	];

	protected $fillable = [
		'company_id',
		'supplier_id',
		'created_by',
		'evaluation_date',
		'quality_rating',
		'delivery_rating',
		'price_rating',
		'service_rating',
		'overall_rating',
		'strengths',
		'weaknesses',
		'improvement_areas',
		'notes'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'created_by');
	}

	public function supplier()
	{
		return $this->belongsTo(Supplier::class);
	}
}
