<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Supplier
 * 
 * @property int $id
 * @property int $company_id
 * @property string $name
 * @property string $code
 * @property string|null $contact_person
 * @property string|null $phone
 * @property string|null $email
 * @property string|null $website
 * @property string|null $address
 * @property string|null $tax_number
 * @property string|null $commercial_register
 * @property float|null $rating
 * @property bool $is_active
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property Collection|AutoPurchaseRule[] $auto_purchase_rules
 * @property Collection|InventoryBatch[] $inventory_batches
 * @property Collection|InventorySerial[] $inventory_serials
 * @property Collection|PurchaseOrder[] $purchase_orders
 * @property Collection|SupplierEvaluation[] $supplier_evaluations
 *
 * El código del proveedor debe ser único dentro de la misma compañía,
 * pero puede repetirse entre diferentes compañías.
 *
 * @package App\Models
 */
class Supplier extends Model
{
	protected $table = 'suppliers';

	protected $casts = [
		'company_id' => 'int',
		'rating' => 'float',
		'is_active' => 'bool'
	];

	protected $fillable = [
		'company_id',
		'name',
		'code',
		'contact_person',
		'phone',
		'email',
		'website',
		'address',
		'tax_number',
		'commercial_register',
		'rating',
		'is_active',
		'notes'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function auto_purchase_rules()
	{
		return $this->hasMany(AutoPurchaseRule::class);
	}

	public function inventory_batches()
	{
		return $this->hasMany(InventoryBatch::class);
	}

	public function inventory_serials()
	{
		return $this->hasMany(InventorySerial::class);
	}

	public function purchase_orders()
	{
		return $this->hasMany(PurchaseOrder::class);
	}

	public function supplier_evaluations()
	{
		return $this->hasMany(SupplierEvaluation::class);
	}
}
