<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalesReturnItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'sales_return_id',
        'item_id',
        'invoice_item_id',
        'quantity',
        'unit_price',
        'tax_rate',
        'tax_amount',
        'discount_amount',
        'total_amount',
        'notes',
    ];

    /**
     * علاقة مع مرتجع المبيعات
     */
    public function salesReturn()
    {
        return $this->belongsTo(SalesReturn::class);
    }

    /**
     * علاقة مع عنصر المخزون
     */
    public function item()
    {
        return $this->belongsTo(InventoryItem::class);
    }

    /**
     * علاقة مع بند الفاتورة الأصلية
     */
    public function invoiceItem()
    {
        return $this->belongsTo(InvoiceItem::class);
    }
}
