<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class SalaryPolicy
 * 
 * @property int $id
 * @property int $company_id
 * @property string $name
 * @property float $late_deduction_rate
 * @property float $absence_deduction_rate
 * @property string $absence_deduction_method
 * @property string $tax_calculation_method
 * @property float $social_insurance_percentage
 * @property float $overtime_rate
 * @property int $allowed_late_minutes
 * @property bool $calculate_overtime
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property User|null $user
 *
 * @package App\Models
 */
class SalaryPolicy extends Model
{
	protected $table = 'salary_policies';

	protected $casts = [
		'company_id' => 'int',
		'late_deduction_rate' => 'float',
		'absence_deduction_rate' => 'float',
		'social_insurance_percentage' => 'float',
		'overtime_rate' => 'float',
		'allowed_late_minutes' => 'int',
		'calculate_overtime' => 'bool',
		'created_by' => 'int',
		'updated_by' => 'int'
	];

	protected $fillable = [
		'company_id',
		'name',
		'late_deduction_rate',
		'absence_deduction_rate',
		'absence_deduction_method',
		'tax_calculation_method',
		'social_insurance_percentage',
		'overtime_rate',
		'allowed_late_minutes',
		'calculate_overtime',
		'created_by',
		'updated_by'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'updated_by');
	}
}
