<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class SalaryComponent
 * 
 * @property int $id
 * @property int $company_id
 * @property int $salary_id
 * @property string $name
 * @property string $type
 * @property float $amount
 * @property bool $is_percentage
 * @property string|null $percentage_of
 * @property bool $is_taxable
 * @property bool $is_fixed
 * @property string $frequency
 * @property Carbon|null $effective_date
 * @property Carbon|null $expiry_date
 * @property string $status
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 *
 * @package App\Models
 */
class SalaryComponent extends Model
{
	protected $table = 'salary_components';

	protected $casts = [
		'company_id' => 'int',
		'salary_id' => 'int',
		'amount' => 'float',
		'is_percentage' => 'bool',
		'is_taxable' => 'bool',
		'is_fixed' => 'bool',
		'effective_date' => 'datetime',
		'expiry_date' => 'datetime',
		'created_by' => 'int',
		'updated_by' => 'int'
	];

	protected $fillable = [
		'company_id',
		'salary_id',
		'name',
		'type',
		'amount',
		'is_percentage',
		'percentage_of',
		'is_taxable',
		'is_fixed',
		'frequency',
		'effective_date',
		'expiry_date',
		'status',
		'created_by',
		'updated_by'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}
}
