<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Salary
 * 
 * @property int $id
 * @property int $company_id
 * @property int $employee_id
 * @property float $basic_salary
 * @property float $housing_allowance
 * @property float $transportation_allowance
 * @property float $other_allowances
 * @property float $total_allowances
 * @property float $gross_salary
 * @property float $tax_deduction
 * @property float $social_insurance
 * @property float $other_deductions
 * @property float $total_deductions
 * @property float $net_salary
 * @property Carbon|null $effective_date
 * @property string $status
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 *
 * @package App\Models
 */
class Salary extends Model
{
	protected $table = 'salaries';

	protected $casts = [
		'company_id' => 'int',
		'employee_id' => 'int',
		'basic_salary' => 'float',
		'housing_allowance' => 'float',
		'transportation_allowance' => 'float',
		'other_allowances' => 'float',
		'total_allowances' => 'float',
		'gross_salary' => 'float',
		'tax_deduction' => 'float',
		'social_insurance' => 'float',
		'other_deductions' => 'float',
		'total_deductions' => 'float',
		'net_salary' => 'float',
		'effective_date' => 'datetime',
		'created_by' => 'int',
		'updated_by' => 'int'
	];

	protected $fillable = [
		'company_id',
		'employee_id',
		'basic_salary',
		'housing_allowance',
		'transportation_allowance',
		'other_allowances',
		'total_allowances',
		'gross_salary',
		'tax_deduction',
		'social_insurance',
		'other_deductions',
		'total_deductions',
		'net_salary',
		'effective_date',
		'status',
		'created_by',
		'updated_by'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}
}
