<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class RewardRedemption
 * 
 * @property int $id
 * @property int $company_id
 * @property int $customer_id
 * @property int $reward_id
 * @property int $points_used
 * @property float|null $discount_amount
 * @property int|null $discount_percentage
 * @property int|null $invoice_id
 * @property string|null $notes
 * @property Carbon $redeemed_at
 * @property string $status
 * @property string|null $deleted_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Company $company
 * @property Customer $customer
 * @property Invoice|null $invoice
 * @property CustomerReward $customer_reward
 *
 * @package App\Models
 */
class RewardRedemption extends Model
{
	use SoftDeletes;
	protected $table = 'reward_redemptions';

	protected $casts = [
		'company_id' => 'int',
		'customer_id' => 'int',
		'reward_id' => 'int',
		'points_used' => 'int',
		'discount_amount' => 'float',
		'discount_percentage' => 'int',
		'invoice_id' => 'int',
		'redeemed_at' => 'datetime'
	];

	protected $fillable = [
		'company_id',
		'customer_id',
		'reward_id',
		'points_used',
		'discount_amount',
		'discount_percentage',
		'invoice_id',
		'notes',
		'redeemed_at',
		'status'
	];

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function customer()
	{
		return $this->belongsTo(Customer::class);
	}

	public function invoice()
	{
		return $this->belongsTo(Invoice::class);
	}

	public function customer_reward()
	{
		return $this->belongsTo(CustomerReward::class, 'reward_id');
	}
}
