<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class PurchaseOrderItem
 * 
 * @property int $id
 * @property int $purchase_order_id
 * @property int $item_id
 * @property float $quantity
 * @property float $received_quantity
 * @property float $unit_price
 * @property float $tax_rate
 * @property float $tax_amount
 * @property float $discount_amount
 * @property float $total_amount
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property InventoryItem $inventory_item
 * @property PurchaseOrder $purchase_order
 *
 * @package App\Models
 */
class PurchaseOrderItem extends Model
{
	protected $table = 'purchase_order_items';

	protected $casts = [
		'purchase_order_id' => 'int',
		'item_id' => 'int',
		'quantity' => 'float',
		'received_quantity' => 'float',
		'unit_price' => 'float',
		'tax_rate' => 'float',
		'tax_amount' => 'float',
		'discount_amount' => 'float',
		'total_amount' => 'float'
	];

	protected $fillable = [
		'purchase_order_id',
		'item_id',
		'quantity',
		'received_quantity',
		'unit_price',
		'tax_rate',
		'tax_amount',
		'discount_amount',
		'total_amount',
		'notes'
	];

	public function inventory_item()
	{
		return $this->belongsTo(InventoryItem::class, 'item_id');
	}

	public function purchase_order()
	{
		return $this->belongsTo(PurchaseOrder::class);
	}
}
