<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class PurchaseOrder
 * 
 * @property int $id
 * @property int $company_id
 * @property int $supplier_id
 * @property int $warehouse_id
 * @property int|null $auto_purchase_rule_id
 * @property bool $is_auto_generated
 * @property int $created_by
 * @property string $po_number
 * @property Carbon $order_date
 * @property Carbon|null $expected_delivery_date
 * @property Carbon|null $delivery_date
 * @property string $status
 * @property float $subtotal
 * @property float $tax_amount
 * @property float $discount_amount
 * @property float $total_amount
 * @property string|null $payment_terms
 * @property string|null $shipping_method
 * @property string|null $notes
 * @property string|null $internal_notes
 * @property int|null $approved_by
 * @property Carbon|null $approved_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property User $user
 * @property AutoPurchaseRule|null $auto_purchase_rule
 * @property Company $company
 * @property Supplier $supplier
 * @property Warehouse $warehouse
 * @property Collection|PurchaseOrderItem[] $purchase_order_items
 *
 * @package App\Models
 */
class PurchaseOrder extends Model
{
	protected $table = 'purchase_orders';

	protected $casts = [
		'company_id' => 'int',
		'supplier_id' => 'int',
		'warehouse_id' => 'int',
		'auto_purchase_rule_id' => 'int',
		'is_auto_generated' => 'bool',
		'created_by' => 'int',
		'order_date' => 'datetime',
		'expected_delivery_date' => 'datetime',
		'delivery_date' => 'datetime',
		'subtotal' => 'float',
		'tax_amount' => 'float',
		'discount_amount' => 'float',
		'total_amount' => 'float',
		'approved_by' => 'int',
		'approved_at' => 'datetime'
	];

	protected $fillable = [
		'company_id',
		'supplier_id',
		'warehouse_id',
		'auto_purchase_rule_id',
		'is_auto_generated',
		'created_by',
		'po_number',
		'order_date',
		'expected_delivery_date',
		'delivery_date',
		'status',
		'subtotal',
		'tax_amount',
		'discount_amount',
		'total_amount',
		'payment_terms',
		'shipping_method',
		'notes',
		'internal_notes',
		'approved_by',
		'approved_at'
	];

	public function user()
	{
		return $this->belongsTo(User::class, 'created_by');
	}

	public function auto_purchase_rule()
	{
		return $this->belongsTo(AutoPurchaseRule::class);
	}

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function supplier()
	{
		return $this->belongsTo(Supplier::class);
	}

	public function warehouse()
	{
		return $this->belongsTo(Warehouse::class);
	}

	public function purchase_order_items()
	{
		return $this->hasMany(PurchaseOrderItem::class);
	}

	/**
	 * العلاقة مع فواتير المشتريات
	 */
	public function purchaseInvoices()
	{
		return $this->hasMany(PurchaseInvoice::class);
	}
}
