<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PurchaseInvoicePayment extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'purchase_invoice_id',
        'created_by',
        'payment_date',
        'amount',
        'payment_method',
        'reference_number',
        'notes',
        'attachment',
    ];

    protected $dates = [
        'payment_date',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    /**
     * العلاقة مع فاتورة المشتريات
     */
    public function purchaseInvoice()
    {
        return $this->belongsTo(PurchaseInvoice::class);
    }

    /**
     * العلاقة مع المستخدم الذي سجل الدفعة
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
