<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectTeamMember
 * 
 * @property int $id
 * @property int $installation_project_id
 * @property int $user_id
 * @property string $role
 * @property Carbon $start_date
 * @property Carbon|null $end_date
 * @property string|null $responsibilities
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property InstallationProject $installation_project
 * @property User $user
 *
 * @package App\Models
 */
class ProjectTeamMember extends Model
{
	protected $table = 'project_team_members';

	protected $casts = [
		'installation_project_id' => 'int',
		'user_id' => 'int',
		'start_date' => 'datetime',
		'end_date' => 'datetime'
	];

	protected $fillable = [
		'installation_project_id',
		'user_id',
		'role',
		'start_date',
		'end_date',
		'responsibilities',
		'notes'
	];

	public function installation_project()
	{
		return $this->belongsTo(InstallationProject::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class);
	}
}
