<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectTaskDependency
 * 
 * @property int $id
 * @property int $task_id
 * @property int $dependency_task_id
 * @property string $dependency_type
 * @property int $lag_days
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property ProjectTask $project_task
 *
 * @package App\Models
 */
class ProjectTaskDependency extends Model
{
	protected $table = 'project_task_dependencies';

	protected $casts = [
		'task_id' => 'int',
		'dependency_task_id' => 'int',
		'lag_days' => 'int'
	];

	protected $fillable = [
		'task_id',
		'dependency_task_id',
		'dependency_type',
		'lag_days'
	];

	public function project_task()
	{
		return $this->belongsTo(ProjectTask::class, 'task_id');
	}
}
