<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectRisk
 * 
 * @property int $id
 * @property int $installation_project_id
 * @property string $title
 * @property string $description
 * @property string $category
 * @property int $probability
 * @property int $severity
 * @property int $risk_score
 * @property string $status
 * @property Carbon $identified_date
 * @property int|null $responsible_user_id
 * @property string|null $mitigation_strategy
 * @property string|null $contingency_plan
 * @property Carbon|null $resolution_date
 * @property string|null $resolution_notes
 * @property int $created_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property User|null $user
 * @property InstallationProject $installation_project
 *
 * @package App\Models
 */
class ProjectRisk extends Model
{
	protected $table = 'project_risks';

	protected $casts = [
		'installation_project_id' => 'int',
		'probability' => 'int',
		'severity' => 'int',
		'risk_score' => 'int',
		'identified_date' => 'datetime',
		'responsible_user_id' => 'int',
		'resolution_date' => 'datetime',
		'created_by' => 'int'
	];

	protected $fillable = [
		'installation_project_id',
		'title',
		'description',
		'category',
		'probability',
		'severity',
		'risk_score',
		'status',
		'identified_date',
		'responsible_user_id',
		'mitigation_strategy',
		'contingency_plan',
		'resolution_date',
		'resolution_notes',
		'created_by'
	];

	public function user()
	{
		return $this->belongsTo(User::class, 'responsible_user_id');
	}

	public function installation_project()
	{
		return $this->belongsTo(InstallationProject::class);
	}
}
