<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectResourceAllocation
 * 
 * @property int $id
 * @property int $project_resource_id
 * @property int $task_id
 * @property float $units
 * @property Carbon $start_date
 * @property Carbon $end_date
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property ProjectResource $project_resource
 * @property ProjectTask $project_task
 *
 * @package App\Models
 */
class ProjectResourceAllocation extends Model
{
	protected $table = 'project_resource_allocations';

	protected $casts = [
		'project_resource_id' => 'int',
		'task_id' => 'int',
		'units' => 'float',
		'start_date' => 'datetime',
		'end_date' => 'datetime'
	];

	protected $fillable = [
		'project_resource_id',
		'task_id',
		'units',
		'start_date',
		'end_date',
		'notes'
	];

	public function project_resource()
	{
		return $this->belongsTo(ProjectResource::class);
	}

	public function project_task()
	{
		return $this->belongsTo(ProjectTask::class, 'task_id');
	}
}
