<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectResource
 * 
 * @property int $id
 * @property int $installation_project_id
 * @property string $name
 * @property string $type
 * @property string|null $description
 * @property string $unit
 * @property float $cost_per_unit
 * @property float $available_units
 * @property float $allocated_units
 * @property string|null $supplier
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property InstallationProject $installation_project
 * @property Collection|ProjectResourceAllocation[] $project_resource_allocations
 *
 * @package App\Models
 */
class ProjectResource extends Model
{
	protected $table = 'project_resources';

	protected $casts = [
		'installation_project_id' => 'int',
		'cost_per_unit' => 'float',
		'available_units' => 'float',
		'allocated_units' => 'float'
	];

	protected $fillable = [
		'installation_project_id',
		'name',
		'type',
		'description',
		'unit',
		'cost_per_unit',
		'available_units',
		'allocated_units',
		'supplier',
		'notes'
	];

	public function installation_project()
	{
		return $this->belongsTo(InstallationProject::class);
	}

	public function project_resource_allocations()
	{
		return $this->hasMany(ProjectResourceAllocation::class);
	}
}
