<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectReportAttachment
 * 
 * @property int $id
 * @property int $project_report_id
 * @property string $file_name
 * @property string $file_path
 * @property int $file_size
 * @property string $file_type
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property ProjectReport $project_report
 *
 * @package App\Models
 */
class ProjectReportAttachment extends Model
{
	protected $table = 'project_report_attachments';

	protected $casts = [
		'project_report_id' => 'int',
		'file_size' => 'int'
	];

	protected $fillable = [
		'project_report_id',
		'file_name',
		'file_path',
		'file_size',
		'file_type'
	];

	public function project_report()
	{
		return $this->belongsTo(ProjectReport::class);
	}
}
