<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectReport
 * 
 * @property int $id
 * @property int $installation_project_id
 * @property string $title
 * @property string $report_type
 * @property Carbon $report_date
 * @property Carbon|null $period_start
 * @property Carbon|null $period_end
 * @property string $content
 * @property int $created_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property User $user
 * @property InstallationProject $installation_project
 * @property Collection|ProjectReportAttachment[] $project_report_attachments
 *
 * @package App\Models
 */
class ProjectReport extends Model
{
	protected $table = 'project_reports';

	protected $casts = [
		'installation_project_id' => 'int',
		'report_date' => 'datetime',
		'period_start' => 'datetime',
		'period_end' => 'datetime',
		'created_by' => 'int'
	];

	protected $fillable = [
		'installation_project_id',
		'title',
		'report_type',
		'report_date',
		'period_start',
		'period_end',
		'content',
		'created_by'
	];

	public function user()
	{
		return $this->belongsTo(User::class, 'created_by');
	}

	public function installation_project()
	{
		return $this->belongsTo(InstallationProject::class);
	}

	public function project_report_attachments()
	{
		return $this->hasMany(ProjectReportAttachment::class);
	}
}
