<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectPayment
 * 
 * @property int $id
 * @property int $installation_project_id
 * @property int|null $invoice_id
 * @property string $payment_number
 * @property float $amount
 * @property Carbon $payment_date
 * @property string $payment_method
 * @property string $payment_type
 * @property string|null $reference_number
 * @property string|null $description
 * @property int $recorded_by
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property InstallationProject $installation_project
 * @property Invoice|null $invoice
 * @property User $user
 *
 * @package App\Models
 */
class ProjectPayment extends Model
{
	protected $table = 'project_payments';

	protected $casts = [
		'installation_project_id' => 'int',
		'invoice_id' => 'int',
		'amount' => 'float',
		'payment_date' => 'datetime',
		'recorded_by' => 'int'
	];

	protected $fillable = [
		'installation_project_id',
		'invoice_id',
		'payment_number',
		'amount',
		'payment_date',
		'payment_method',
		'payment_type',
		'reference_number',
		'description',
		'recorded_by',
		'notes'
	];

	public function installation_project()
	{
		return $this->belongsTo(InstallationProject::class);
	}

	public function invoice()
	{
		return $this->belongsTo(Invoice::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'recorded_by');
	}
}
