<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectMilestone
 * 
 * @property int $id
 * @property int $installation_project_id
 * @property string $title
 * @property string|null $description
 * @property Carbon $due_date
 * @property Carbon|null $completion_date
 * @property float|null $payment_amount
 * @property string $status
 * @property int $order_number
 * @property string|null $deliverables
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property InstallationProject $installation_project
 *
 * @package App\Models
 */
class ProjectMilestone extends Model
{
	protected $table = 'project_milestones';

	protected $casts = [
		'installation_project_id' => 'int',
		'due_date' => 'datetime',
		'completion_date' => 'datetime',
		'payment_amount' => 'float',
		'order_number' => 'int'
	];

	protected $fillable = [
		'installation_project_id',
		'title',
		'description',
		'due_date',
		'completion_date',
		'payment_amount',
		'status',
		'order_number',
		'deliverables',
		'notes'
	];

	public function installation_project()
	{
		return $this->belongsTo(InstallationProject::class);
	}
}
