<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectIssue
 * 
 * @property int $id
 * @property int $installation_project_id
 * @property int|null $project_phase_id
 * @property int|null $project_task_id
 * @property string $title
 * @property string $description
 * @property string $priority
 * @property string $status
 * @property string $type
 * @property Carbon $reported_date
 * @property Carbon|null $resolution_date
 * @property string|null $resolution_details
 * @property int $reported_by
 * @property int|null $assigned_to
 * @property string|null $impact
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property User $user
 * @property InstallationProject $installation_project
 * @property ProjectPhase|null $project_phase
 * @property ProjectTask|null $project_task
 *
 * @package App\Models
 */
class ProjectIssue extends Model
{
	protected $table = 'project_issues';

	protected $casts = [
		'installation_project_id' => 'int',
		'project_phase_id' => 'int',
		'project_task_id' => 'int',
		'reported_date' => 'datetime',
		'resolution_date' => 'datetime',
		'reported_by' => 'int',
		'assigned_to' => 'int'
	];

	protected $fillable = [
		'installation_project_id',
		'project_phase_id',
		'project_task_id',
		'title',
		'description',
		'priority',
		'status',
		'type',
		'reported_date',
		'resolution_date',
		'resolution_details',
		'reported_by',
		'assigned_to',
		'impact',
		'notes'
	];

	public function user()
	{
		return $this->belongsTo(User::class, 'reported_by');
	}

	public function installation_project()
	{
		return $this->belongsTo(InstallationProject::class);
	}

	public function project_phase()
	{
		return $this->belongsTo(ProjectPhase::class);
	}

	public function project_task()
	{
		return $this->belongsTo(ProjectTask::class);
	}
}
