<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class ProjectInventoryRequestItem
 * 
 * @property int $id
 * @property int $project_inventory_request_id
 * @property int $inventory_item_id
 * @property int $warehouse_id
 * @property float $quantity
 * @property float $fulfilled_quantity
 * @property string $status
 * @property string|null $notes
 * @property string|null $rejection_reason
 * @property string $priority
 * @property int|null $task_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 *
 * @package App\Models
 */
class ProjectInventoryRequestItem extends Model
{
	use SoftDeletes;
	protected $table = 'project_inventory_request_items';

	protected $casts = [
		'project_inventory_request_id' => 'int',
		'inventory_item_id' => 'int',
		'warehouse_id' => 'int',
		'quantity' => 'float',
		'fulfilled_quantity' => 'float',
		'task_id' => 'int'
	];

	protected $fillable = [
		'project_inventory_request_id',
		'inventory_item_id',
		'warehouse_id',
		'quantity',
		'fulfilled_quantity',
		'status',
		'notes',
		'rejection_reason',
		'priority',
		'task_id'
	];
}
