<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class ProjectInventoryRequest
 * 
 * @property int $id
 * @property int $company_id
 * @property int $installation_project_id
 * @property int|null $project_phase_id
 * @property string $request_number
 * @property string $status
 * @property int $requested_by
 * @property int|null $approved_by
 * @property Carbon $requested_date
 * @property Carbon $required_date
 * @property Carbon|null $approval_date
 * @property Carbon|null $fulfillment_date
 * @property string|null $notes
 * @property string|null $rejection_reason
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property User $user
 * @property Company $company
 * @property InstallationProject $installation_project
 * @property ProjectPhase|null $project_phase
 *
 * @package App\Models
 */
class ProjectInventoryRequest extends Model
{
	use SoftDeletes;
	protected $table = 'project_inventory_requests';

	protected $casts = [
		'company_id' => 'int',
		'installation_project_id' => 'int',
		'project_phase_id' => 'int',
		'requested_by' => 'int',
		'approved_by' => 'int',
		'requested_date' => 'datetime',
		'required_date' => 'datetime',
		'approval_date' => 'datetime',
		'fulfillment_date' => 'datetime'
	];

	protected $fillable = [
		'company_id',
		'installation_project_id',
		'project_phase_id',
		'request_number',
		'status',
		'requested_by',
		'approved_by',
		'requested_date',
		'required_date',
		'approval_date',
		'fulfillment_date',
		'notes',
		'rejection_reason'
	];

	public function user()
	{
		return $this->belongsTo(User::class, 'requested_by');
	}

	public function company()
	{
		return $this->belongsTo(Company::class);
	}

	public function installation_project()
	{
		return $this->belongsTo(InstallationProject::class);
	}

	public function project_phase()
	{
		return $this->belongsTo(ProjectPhase::class);
	}
}
