<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectExpense
 * 
 * @property int $id
 * @property int $installation_project_id
 * @property int|null $project_phase_id
 * @property string $title
 * @property string|null $description
 * @property float $amount
 * @property Carbon $expense_date
 * @property string $category
 * @property string $payment_method
 * @property string|null $receipt_number
 * @property string|null $receipt_file
 * @property int $recorded_by
 * @property int|null $approved_by
 * @property Carbon|null $approved_at
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property User $user
 * @property InstallationProject $installation_project
 * @property ProjectPhase|null $project_phase
 *
 * @package App\Models
 */
class ProjectExpense extends Model
{
	protected $table = 'project_expenses';

	protected $casts = [
		'installation_project_id' => 'int',
		'project_phase_id' => 'int',
		'amount' => 'float',
		'expense_date' => 'datetime',
		'recorded_by' => 'int',
		'approved_by' => 'int',
		'approved_at' => 'datetime'
	];

	protected $fillable = [
		'installation_project_id',
		'project_phase_id',
		'title',
		'description',
		'amount',
		'expense_date',
		'category',
		'payment_method',
		'receipt_number',
		'receipt_file',
		'recorded_by',
		'approved_by',
		'approved_at',
		'notes'
	];

	public function user()
	{
		return $this->belongsTo(User::class, 'recorded_by');
	}

	public function installation_project()
	{
		return $this->belongsTo(InstallationProject::class);
	}

	public function project_phase()
	{
		return $this->belongsTo(ProjectPhase::class);
	}
}
