<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectElevator
 * 
 * @property int $id
 * @property int $installation_project_id
 * @property int|null $elevator_id
 * @property string $elevator_type
 * @property string $model
 * @property string $manufacturer
 * @property int $capacity
 * @property int $floors_count
 * @property float $speed
 * @property float $unit_price
 * @property string $status
 * @property Carbon|null $expected_delivery_date
 * @property Carbon|null $actual_delivery_date
 * @property Carbon|null $expected_installation_date
 * @property Carbon|null $actual_installation_date
 * @property string|null $specifications
 * @property string|null $notes
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Elevator|null $elevator
 * @property InstallationProject $installation_project
 * @property Collection|ProjectChecklist[] $project_checklists
 *
 * @package App\Models
 */
class ProjectElevator extends Model
{
	protected $table = 'project_elevators';

	protected $casts = [
		'installation_project_id' => 'int',
		'elevator_id' => 'int',
		'capacity' => 'int',
		'floors_count' => 'int',
		'speed' => 'float',
		'unit_price' => 'float',
		'expected_delivery_date' => 'datetime',
		'actual_delivery_date' => 'datetime',
		'expected_installation_date' => 'datetime',
		'actual_installation_date' => 'datetime'
	];

	protected $fillable = [
		'installation_project_id',
		'elevator_id',
		'elevator_type',
		'model',
		'manufacturer',
		'capacity',
		'floors_count',
		'speed',
		'unit_price',
		'status',
		'expected_delivery_date',
		'actual_delivery_date',
		'expected_installation_date',
		'actual_installation_date',
		'specifications',
		'notes'
	];

	public function elevator()
	{
		return $this->belongsTo(Elevator::class);
	}

	public function installation_project()
	{
		return $this->belongsTo(InstallationProject::class);
	}

	public function project_checklists()
	{
		return $this->hasMany(ProjectChecklist::class);
	}
}
