<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectDocument
 * 
 * @property int $id
 * @property int $installation_project_id
 * @property string $title
 * @property string $type
 * @property string $file_path
 * @property string $file_name
 * @property string $file_extension
 * @property int $file_size
 * @property string|null $description
 * @property int $uploaded_by
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property InstallationProject $installation_project
 * @property User $user
 *
 * @package App\Models
 */
class ProjectDocument extends Model
{
	protected $table = 'project_documents';

	protected $casts = [
		'installation_project_id' => 'int',
		'file_size' => 'int',
		'uploaded_by' => 'int'
	];

	protected $fillable = [
		'installation_project_id',
		'title',
		'type',
		'file_path',
		'file_name',
		'file_extension',
		'file_size',
		'description',
		'uploaded_by'
	];

	public function installation_project()
	{
		return $this->belongsTo(InstallationProject::class);
	}

	public function user()
	{
		return $this->belongsTo(User::class, 'uploaded_by');
	}
}
