<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProjectChecklistItem
 * 
 * @property int $id
 * @property int $project_checklist_id
 * @property string $item
 * @property string|null $description
 * @property bool $is_required
 * @property bool $is_completed
 * @property int|null $completed_by
 * @property Carbon|null $completed_at
 * @property string|null $notes
 * @property int $order_number
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property User|null $user
 * @property ProjectChecklist $project_checklist
 *
 * @package App\Models
 */
class ProjectChecklistItem extends Model
{
	protected $table = 'project_checklist_items';

	protected $casts = [
		'project_checklist_id' => 'int',
		'is_required' => 'bool',
		'is_completed' => 'bool',
		'completed_by' => 'int',
		'completed_at' => 'datetime',
		'order_number' => 'int'
	];

	protected $fillable = [
		'project_checklist_id',
		'item',
		'description',
		'is_required',
		'is_completed',
		'completed_by',
		'completed_at',
		'notes',
		'order_number'
	];

	public function user()
	{
		return $this->belongsTo(User::class, 'completed_by');
	}

	public function project_checklist()
	{
		return $this->belongsTo(ProjectChecklist::class);
	}
}
